unit uSettings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, FileCtrl, ShellCtrls, Buttons, DBCtrls, DB, ADODB,
  dbcgrids, ExtCtrls, xmldom, XMLIntf, msxmldom, XMLDoc, IniFiles,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, EhLibVCL, GridsEh,
  DBAxisGridsEh, DBGridEh;

type
  TfrmSettings = class(TForm)
    ExportLbl: TLabel;
    EditPuth: TEdit;
    ProxyGB: TGroupBox;
    Ip: TEdit;
    Socket: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    SettingsPageControl: TPageControl;
    BlankSheet: TTabSheet;
    MainSheet: TTabSheet;
    ExportFolderGB: TGroupBox;
    blankCodeXMLDoc: TXMLDocument;
    BlankLbl: TLabel;
    blankCodeCB: TComboBox;
    PredprDS: TDataSource;
    OperSheet: TTabSheet;
    OperDBLookupLB: TDBLookupListBox;
    OperDBCtrlGrid: TDBCtrlGrid;
    SelDBCB: TDBCheckBox;
    NameGrOperDBText: TDBText;
    DeistSelQ: TADOQuery;
    DeistChanger: TADOQuery;
    DeistSelQDS: TDataSource;
    DeistChangerDS: TDataSource;
    TypeOperRG: TRadioGroup;
    SelAllOperCB: TCheckBox;
    ChangePicker: TADOQuery;
    AdditionalGB: TGroupBox;
    BranchCodePrincipal: TCheckBox;
    VisibleRadioGroup: TRadioGroup;
    ChangePickerbuh: TADOQuery;
    ARMSelect: TRadioGroup;
    StartNumberGB: TGroupBox;
    StartNumberEdit: TEdit;
    RemoteStatusCB: TCheckBox;
    PredprsDBGridEh: TDBGridEh;
    PredprsQ: TADOQuery;
    SelectFolderBtn: TButton;
    SaveBtn: TButton;
    CancelBtn: TButton;
    BottomPanel: TPanel;
    DBGridEh1: TDBGridEh;
    DeistChangeridGrOper: TSmallintField;
    DeistChangerNameGrOper: TStringField;
    DeistChangerESCFPriznak: TBooleanField;
    procedure SaveBtnClick(Sender: TObject);
    procedure FormMouseWheelUp(Sender: TObject; Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
    procedure FormMouseWheelDown(Sender: TObject; Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure blankCodeCBExit(Sender: TObject);
    procedure TypeOperRGClick(Sender: TObject);
    procedure SelAllOperCBClick(Sender: TObject);
    procedure OperDBLookupLBKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure OperDBLookupLBMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ARMSelectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure IpKeyPress(Sender: TObject; var Key: Char);
    procedure PredprsQAfterScroll(DataSet: TDataSet);
    procedure blankCodeCBChange(Sender: TObject);
    procedure SelectFolderBtnClick(Sender: TObject);
    procedure DeistChangerESCFPriznakChange(Sender: TField);
  private
    { Private declarations }
    procedure DeistChange();
    procedure PostSelDBCB();
  public
    { Public declarations }
  end;

var
  frmSettings: TfrmSettings;
  divisionList: IXMLNodeList;

implementation

uses
  uDM;

{$R *.dfm}

procedure TfrmSettings.PostSelDBCB();
begin
  if not DeistChanger.IsEmpty then
  begin
    SelDBCB.DataSource.DataSet.Edit;
    SelDBCB.DataSource.DataSet.Post;
  end;
end;

procedure TfrmSettings.PredprsQAfterScroll(DataSet: TDataSet);
var
  i: Integer;
  fl: Boolean;
begin
  fl := False;

  with blankCodeXMLDoc.DocumentElement do
  begin
    divisionList := ChildNodes['divisionList'].ChildNodes;

    for i := 0 to divisionList.Count - 1 do
    begin
      if divisionList[i].ChildNodes['kodSkl'].Text = PredprsQ.FieldByName('idPredpr').AsString then
      begin
        blankCodeCB.ItemIndex := StrToInt(divisionList[i].ChildNodes['item'].Text);
        fl := true;
        break;
      end;
    end;

    if not fl then
      blankCodeCB.ItemIndex := 0;
  end;
end;

procedure TfrmSettings.DeistChange();
begin
  PostSelDBCB;

  DeistChanger.Close;
  DeistChanger.Parameters.ParamByName('Type').Value := '%' + TypeOperRG.Items[TypeOperRG.ItemIndex] + '%';
  DeistChanger.Parameters.ParamByName('Deist').Value := OperDBLookupLB.KeyValue;
  DeistChanger.Open;

  SelAllOperCB.Enabled := not DeistChanger.IsEmpty;
  OperDBCtrlGrid.Enabled := not DeistChanger.IsEmpty;
end;

procedure TfrmSettings.DeistChangerESCFPriznakChange(Sender: TField);
begin
  if DeistChanger.State in [dsEdit] then
    DeistChanger.Post;
end;

procedure TfrmSettings.SaveBtnClick(Sender: TObject);
var
  i: Integer;
  Ini: Tinifile;
begin
  Ini := TiniFile.Create(extractfilepath(paramstr(0)) + 'Gear.ini');
  Ini.WriteString('Path', 'Path', EditPuth.Text);
  Ini.WriteString('Proxy', 'Ip', Ip.Text);
  Ini.WriteString('Proxy', 'Socket', Socket.Text);
  Ini.WriteString('DopUNN', 'Value', BoolToStr(BranchCodePrincipal.Checked));
  Ini.WriteInteger('Visible', 'Value', VisibleRadioGroup.ItemIndex);
  Ini.WriteString('Number', 'StartNumber', StartNumberEdit.Text);
  Ini.WriteString('Status', 'Remote', BoolToStr(RemoteStatusCB.Checked));
  Ini.Free;

  with blankCodeXMLDoc.DocumentElement do
  begin
    divisionList := ChildNodes['divisionList'].ChildNodes;
    for i := divisionList.Count - 1 downto 0 do
    begin
      if (divisionList[i].ChildNodes['item'].Text = '0') or (divisionList[i].ChildNodes
        ['item'].Text = '-1') then
        divisionList.Delete(i);
    end;
  end;

  blankCodeXMLDoc.SaveToFile('blankCode.xml');
end;

procedure TfrmSettings.FormMouseWheelUp(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
  if (SettingsPageControl.ActivePageIndex = 2) and (not DeistChanger.IsEmpty) then
    DeistChanger.Prior;
end;

procedure TfrmSettings.FormMouseWheelDown(Sender: TObject; Shift: TShiftState;
  MousePos: TPoint; var Handled: Boolean);
begin
  if (SettingsPageControl.ActivePageIndex = 2) and (not DeistChanger.IsEmpty) then
    DeistChanger.Next;
end;

procedure TfrmSettings.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  PostSelDBCB;
end;

procedure TfrmSettings.blankCodeCBChange(Sender: TObject);
begin
  PredprsDBGridEh.SetFocus;
end;

procedure TfrmSettings.blankCodeCBExit(Sender: TObject);
var
  i: Integer;
  fl: Boolean;
begin
  fl := False;
  with blankCodeXMLDoc.DocumentElement do
  begin
    divisionList := ChildNodes['divisionList'].ChildNodes;

    for i := 0 to divisionList.Count - 1 do
    begin
      if divisionList[i].ChildNodes['kodSkl'].Text = PredprsQ.FieldByName('idPredpr').AsString then
      begin
        divisionList[i].ChildValues['item'] := blankCodeCB.ItemIndex;
        fl := true;
        break;
      end;
    end;

    if not fl then
    begin
      with ChildNodes['divisionList'].AddChild('division') do
      begin
        ChildValues['kodSkl'] := PredprsQ.FieldByName('idPredpr').AsString;
        ChildValues['item'] := blankCodeCB.ItemIndex;
      end;
    end;
  end;
end;

procedure TfrmSettings.SelectFolderBtnClick(Sender: TObject);
var
  Ini: Tinifile;
  S1: string;
begin
  Ini := TiniFile.Create(extractfilepath(paramstr(0)) + 'Gear.ini');
  S1 := Ini.ReadString('Path', 'Path', '');
  Ini.Free;

  if SelectDirectory(' ', '', S1) then
    EditPuth.Text := S1;
end;

procedure TfrmSettings.TypeOperRGClick(Sender: TObject);
begin
  with DeistChanger do
    if not IsEmpty then
    begin
      Close;
      Parameters.ParamByName('Type').Value := '%' + TypeOperRG.Items[TypeOperRG.ItemIndex] + '%';
      Parameters.ParamByName('Deist').Value := OperDBLookupLB.KeyValue;
      Open;
    end;
end;

procedure TfrmSettings.SelAllOperCBClick(Sender: TObject);
begin
  with ChangePicker do
  begin
    Parameters.ParamByName('Prizn').Value := SelAllOperCB.Checked;
    Parameters.ParamByName('Type').Value := '%' + TypeOperRG.Items[TypeOperRG.ItemIndex] + '%';
    Parameters.ParamByName('Deist').Value := OperDBLookupLB.KeyValue;
    ExecSQL;
  end;

  with DeistChanger do
  begin
    Close;
    Parameters.ParamByName('Type').Value := '%' + TypeOperRG.Items[TypeOperRG.ItemIndex] + '%';
    Parameters.ParamByName('Deist').Value := OperDBLookupLB.KeyValue;
    Open;
  end;
end;

procedure TfrmSettings.OperDBLookupLBKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  DeistChange;
end;

procedure TfrmSettings.OperDBLookupLBMouseUp(Sender: TObject; Button:
  TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeistChange;
end;

procedure TfrmSettings.ARMSelectClick(Sender: TObject);
begin
  PostSelDBCB;

  if ARMSelect.ItemIndex = 0 then
  begin
    ChangePicker.SQL[1] := 'SET ESCFPriznak=:Prizn';
    DeistChanger.SQL[1] := 'tbGrOper.ESCFPriznak';
  end
  else
  begin
    ChangePicker.SQL[1] := 'SET ESCFPriznakBuh=:Prizn';
    DeistChanger.SQL[1] := 'tbGrOper.ESCFPriznakBuh as ESCFPriznak';
  end;

  DeistChange;
end;

procedure TfrmSettings.FormCreate(Sender: TObject);
var
  Ini: Tinifile;
begin
  Ini := TiniFile.Create(extractfilepath(paramstr(0)) + 'Gear.ini');
  EditPuth.Text := Ini.ReadString('Path', 'Path', '');
  Ip.Text := Ini.ReadString('Proxy', 'Ip', '');
  Socket.Text := Ini.ReadString('Proxy', 'Socket', '');
  BranchCodePrincipal.Checked := StrToBool(Ini.ReadString('DopUNN', 'Value', '0'));
  VisibleRadioGroup.ItemIndex := Ini.ReadInteger('Visible', 'Value', 0);
  StartNumberEdit.Text := Ini.ReadString('Number', 'StartNumber', '1000000000');
  RemoteStatusCB.Checked := StrToBool(Ini.ReadString('Status', 'Remote', '0'));
  Ini.Free;

  blankCodeXMLDoc.FileName := 'blankCode.xml';
  blankCodeXMLDoc.Active := True;

  DeistSelQ.Close;
  DeistSelQ.Open;

  PredprsQ.Close;
  PredprsQ.Open;

  SettingsPageControl.ActivePageIndex := 0;
end;

procedure TfrmSettings.IpKeyPress(Sender: TObject; var Key: Char);
begin
  if not CharInSet(Key, ['0'..'9', '.', #8]) then
    Key := #0;
end;

end.

